import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

// Referenced classes of package duggelz.jape:
//            DataChangeEvent, DataChangeMixin, FieldView, Structure,
//            DataChangeListener

public class TextView extends TextField implements FieldView, TextListener {

    public TextView(String fieldName, int length) {
        super(length);
        suppressEvents = false;
        modified = false;
        mixin = new DataChangeMixin();
        this.fieldName = fieldName;
        this.length = length;
        addTextListener(this);
    }

    public void addDataChangeListener(DataChangeListener l) {
        mixin.addDataChangeListener(l);
    }

    public void commit(String newValue) {
        if (struct != null) {
            String oldValue = struct.get(fieldName);
            if (oldValue == null && newValue != null ||
                oldValue != null && !oldValue.equals(newValue)) {
                modified = true;
                struct.set(fieldName, newValue);
                fireDataChangeEvent(new DataChangeEvent(this, this.oldValue,
                        newValue));
            }
        }
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        mixin.fireDataChangeEvent(e);
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getValue() {
        return getText();
    }

    public boolean isModified() {
        return modified;
    }

    public synchronized void refresh() {
        try {
            suppressEvents = true;
            String value = null;
            if (struct != null) {
                value = struct.get(fieldName);
            }
            if (value != null) {
                setText(value);
            } else {
                setText("");
            }
            oldValue = value;
            modified = false;
        } finally {
            suppressEvents = false;
        }
    }

    public void removeDataChangeListener(DataChangeListener l) {
        mixin.removeDataChangeListener(l);
    }

    public void setStruct(Structure struct) {
        this.struct = struct;
    }

    public void textValueChanged(TextEvent event) {
        if (suppressEvents) {
            return;
        }
        String newValue = getText();
        if (newValue.length() <= length) {
            commit(newValue);
            oldValue = newValue;
        } else {
            setText(oldValue);
        }
    }

    private boolean suppressEvents;
    private String fieldName;
    private int length;
    private boolean modified;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin;
    static final long serialVersionUID = 030265;
}
